(function ($) {
    "use strict";

    $(document).ready(function () {
        $("#download_btn").on("click", function () {
            var originalElement = document.getElementById("download_section");
            
            var clonedElement = originalElement.cloneNode(true);
            var baseColor = $("#download_section").data("color"); 
            
            // if (!baseColor) baseColor = "#0c8c0a";
            
            // var imageColorName = getClosestColorName(baseColor);
            // var imageFile = `invoicepdf/${imageColorName}.jpg`;
            
            
            // var baseColor = $("#download_section").data("color") || "#0c8c0a";
            var darkColor = $("#download_section").data("dark-color") || baseColor;
            var lightColor = $("#download_section").data("light-color") || baseColor;
            var imageFile = $("#download_section").data("bg-image") || "invoicepdf/hosting_bg.jpg";



            
            // Apply critical styling to the clone
            clonedElement.style.width = "850px";
            clonedElement.style.position = "absolute";
            clonedElement.style.left = "-9999px";
            clonedElement.style.top = "0";
            clonedElement.style.padding = "40px";
            clonedElement.style.backgroundColor = "white"; // Force white background
            
            // Ensure background image loads (if needed)
            // clonedElement.style.backgroundImage = "url('invoicepdf/hosting_bg.png')";
            clonedElement.style.backgroundImage = `url('${imageFile}')`;
            clonedElement.style.backgroundRepeat = "no-repeat";
            clonedElement.style.backgroundSize = "100% 100%";
            
        
            
            // Fix tables to prevent overflow
            var tables = clonedElement.getElementsByTagName("table");
            for (var i = 0; i < tables.length; i++) {
                tables[i].style.width = "100%";
                tables[i].style.borderCollapse = "collapse";
            }
            
            // Force logo dimensions and source
            var logo = clonedElement.querySelector("#logo-final");
            if (logo) {
                logo.style.width = "150px";
                logo.style.height = "auto";
                logo.src = logo.src; // Trigger reload
            }
            
            // Apply inline styles directly to cloned table headers
            var tableHeaders = clonedElement.querySelectorAll(".invoice-table th");
            tableHeaders.forEach(function(th) {
                th.style.background = `linear-gradient(180deg, ${darkColor} 0%, ${lightColor} 100%)`;
                th.style.color = "#ffffff"; // optional: ensure text is visible
            });
            
            // Apply inline styles directly to the footer
            var footer = clonedElement.querySelector(".footer-info");
            if (footer) {
                footer.style.backgroundImage = `linear-gradient(180deg, ${darkColor} 0%, ${lightColor} 100%)`;
                footer.style.color = "#ffffff"; // optional
                footer.style.borderRadius = "30px";
                footer.style.padding ="20px";
            }
         
        var footerTexts = clonedElement.querySelectorAll(".footer-info .f-text");
footerTexts.forEach(function(p) {
    p.style.color = "#ffffff";
});

            document.body.appendChild(clonedElement);




            // Delay to ensure all assets load
            setTimeout(() => {
                html2canvas(clonedElement, {
                    scale: 3, // Higher resolution
                    logging: true, // Debugging
                    useCORS: true, // Allow cross-origin images
                    allowTaint: true, // Allow external images
                    backgroundColor: "#FFFFFF", // Force white background
                    onclone: function(clonedDoc) {
                        // Additional fixes if elements render incorrectly
                        clonedDoc.body.style.fontFamily = "Arial, sans-serif";
                    }
                }).then(function (canvas) {
                    var imgData = canvas.toDataURL("image/png", 1.0); // Maximum quality
                    
                    // Create PDF in portrait mode (A4)
                    var pdf = new jsPDF("p", "mm", "a4");
                    var imgWidth = 210; // A4 width in mm
                    var imgHeight = (canvas.height * imgWidth) / canvas.width;
                    
                    pdf.addImage(imgData, "PNG", 0, 0, imgWidth, imgHeight);
                    pdf.save("invoice.pdf");
                    
                    // Clean up
                    document.body.removeChild(clonedElement);
                }).catch(error => {
                    console.error("PDF generation failed:", error);
                    document.body.removeChild(clonedElement); // Clean up even on error
                });
            }, 100); // 1-second delay for assets
        });
    });
})(jQuery);